<?php

/**
 * This is the model class for table "Przetarg".
 *
 * The followings are the available columns in table 'Przetarg':
 * @property double $id
 * @property double $idKlasy
 * @property double $idAkcji
 * @property double $idKontrahenta
 * @property double $poziomTrudnosci
 *
 * @property \Kontrahent $kontrahent
 * @property \Klasa      $klasa
 * @property \Akcja      $akcja
 * @property int         $isInUse
 */
class Przetarg extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Przetarg the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Przetarg';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idKlasy, idAkcji, idKontrahenta, poziomTrudnosci', 'required'),
			array('idKlasy, idAkcji, idKontrahenta, poziomTrudnosci', 'numerical'),

			array('id, idKlasy, idAkcji, idKontrahenta, poziomTrudnosci', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'akcja'=>array(self::BELONGS_TO, 'Akcja', 'idAkcji'),
			'klasa'=>array(self::BELONGS_TO, 'Klasa', 'idKlasy'),
			'kontrahent'=>array(self::BELONGS_TO, 'Kontrahent', 'idKontrahenta'),
			'grupy'=>array(self::HAS_MANY, 'PrzetargGrupa', 'idPrzetargu'),
			'isInUse'=>array(self::STAT, 'PrzetargGrupa', 'idPrzetargu'),
			'pendingGroups'=>array(self::STAT, 'PrzetargGrupa', 'idPrzetargu',
				'condition' => '"t"."status" = ' . PrzetargGrupa::TENDER_STATUS_ACCEPTATION_REQUEST),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Przetarg', 'id'),
			'idKlasy'=>Yii::t('Przetarg', 'idKlasy'),
			'idAkcji'=>Yii::t('Przetarg', 'idAkcji'),
			'idKontrahenta'=>Yii::t('Przetarg', 'idKontrahenta'),
			'poziomTrudnosci'=>Yii::t('Przetarg', 'poziomTrudnosci'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idKlasy', $this->idKlasy);
		$criteria->compare('idAkcji', $this->idAkcji);
		$criteria->compare('idKontrahenta', $this->idKontrahenta);
		$criteria->compare('poziomTrudnosci', $this->poziomTrudnosci);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getPoziomStr()
	{
		return Zlecenie::getPoziomString($this->poziomTrudnosci);
	}

	public static function initialize($teacherId)
	{
		$actions = Yii::app()->db->createCommand('
			select
				ak."idKlasy", k."nazwa", s."nazwa" "szkola", a."id" "idAkcji", l."order"
			from "AdminKlasy" ak
			left join "Akcja" a on a."nazwa" = :tag
			left join "Lekcja" l on l."id" = a."idLekcji"
			left join "Klasa" k on k."id" = ak."idKlasy"
			left join "Szkola" s on s."id" = k."idSzkoly"
			left join "Przetarg" p on p."idKlasy" = ak."idKlasy" and p."idAkcji" = a."id"
			where ak."idAdmina" = :adminId
			group by ak."idKlasy", a."id", k."nazwa", l."order", s."nazwa"
			HAVING count(p."id") = 0
		')->queryAll(true, array(
			':adminId' => $teacherId,
			':tag' => Akcja::ACTION_TENDER
		));
		if (empty($actions))
			return false;

		$flashes = array();
		$tendersCount = ParametryGry::getValue('PRZETARG_ILOSC', 4);

		$kontrahenciDziedzina = array();

		for($i = 0; $i < 4; $i++)
		{
			$dziedzinaIndx = $i + 1;
			$kontrahenciDziedzina[$dziedzinaIndx] = Yii::app()->db->createCommand('
				select * from (
					select k."id" from "Kontrahent" k
					where k."typ" = :type and k."idBudynku"  is not null and k."idDziedziny" = :idDziedziny
					order by DBMS_RANDOM.RANDOM
				) where ROWNUM <= :count
			')->queryAll(true, array(
				':type' => Kontrahent::TYPE_STANDARD,
				':count' => $tendersCount * count($actions),
				':idDziedziny' => $dziedzinaIndx
			));
		}

		foreach ($actions as $index => $action)
		{
			//wylosowanie numerkow dla dziedzin
			for($i=0; $i < 4; $i++)
			{
				$dziedzinaIndx = $i + 1;
				$indexes[$dziedzinaIndx] = array_rand($kontrahenciDziedzina[$dziedzinaIndx], $tendersCount / 4);

				if(is_array($indexes[$dziedzinaIndx]))
				{
					foreach($indexes[$dziedzinaIndx] as $indx)
					{
						$tender = new Przetarg;
						$tender->idAkcji = $action['idAkcji'];
						$tender->idKlasy = $action['idKlasy'];
						$tender->idKontrahenta = $kontrahenciDziedzina[$dziedzinaIndx][$indx]['id'];
						$tender->poziomTrudnosci = 1; // TYLKO LATWE PRZETARGI rand(1, 3);
						$tender->save(false);
					}
				}
				else
				{
					$tender = new Przetarg;
					$tender->idAkcji = $action['idAkcji'];
					$tender->idKlasy = $action['idKlasy'];
					$tender->idKontrahenta = $kontrahenciDziedzina[$dziedzinaIndx][$indexes[$dziedzinaIndx]]['id'] ;
					$tender->poziomTrudnosci = 1; // TYLKO LATWE PRZETARGI rand(1, 3);
					$tender->save(false);
				}
			}

			$flashes[] = 'Wygenerowano przetargi dla klasy ' . $action['nazwa']
				. ' (' . $action['szkola'] . ') w lekcji #' . $action['order']
				. ' (akcja: #' . $action['idAkcji'] . ').';
		}

		return $flashes;
	}
}
